using System;
using System.Web;
using System.Xml;
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.Publishing.Extensions.Placeholders;
using Microsoft.ContentManagement.Publishing.Events;

namespace ContosoNetControls
{
	/// <summary>
	/// Summary description for CustomPropertiesEventHandler.
	/// </summary>
	public class CustomPropertiesEventHandler
	{
		public CustomPropertiesEventHandler()
		{
			//
			// TODO: Add constructor logic here
			//
		}
		public static void SyncCustomProperties (Object sender, ChangingEventArgs e, string placeholderName)
		{
			CmsContext context = e.Context;
			Posting posting = e.Target as Posting;

			if (posting != null)
			{
				context.CommitAll();

				XmlPlaceholder xmlPlaceholder = 
					posting.Placeholders[placeholderName]
					as XmlPlaceholder;
				if (xmlPlaceholder != null)
				{
					XmlDocument propXmlDoc = new XmlDocument();
					propXmlDoc.LoadXml (xmlPlaceholder.XmlAsString);
					foreach (CustomProperty p in posting.CustomProperties)
					{
						p.Value = GetFromXml (propXmlDoc, p.Name);
					}
				}
				context.CommitAll();
			}
		}

		private static string GetFromXml (XmlDocument propXmlDoc, string propName)
		{
			string elementName = propName.Replace (" ", "");

			XmlNodeList nodes = propXmlDoc.GetElementsByTagName (elementName);
			if (nodes.Count <= 0)
			{
				// It wasn't in the XML, probably a new property for this posting
				// so return the actual property
				return (CmsHttpContext.Current.Posting.CustomProperties[propName].Value);
			}
			XmlElement propElement = nodes[0] as XmlElement;
			if (propElement == null)
			{
				// It wasn't in the XML, probably a new property for this posting
				// so return the actual property
				return (CmsHttpContext.Current.Posting.CustomProperties[propName].Value);
			}
			return (System.Web.HttpUtility.HtmlDecode (propElement.InnerText));
		}

	}
}
